/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;

public class SolarisNetProtocol
implements OiilQuery {
    public static String PKGINFO = "/bin/pkginfo";
    public static String LU62 = "SUNWappc";
    public static String SPX = "SUNWipx";
    public static String tcpName = "TCP/IP";
    public static String lu62Name = "LU6.2";
    public static String spxName = "SPX";

    public Object performQuery(Vector inputs) throws OiilQueryException {
        Vector<String> store = new Vector<String>();
        String command0 = PKGINFO + " " + LU62;
        String command1 = PKGINFO + " " + SPX;
        if (System.getProperty("os.name").equals("Solaris") || System.getProperty("os.name").equals("SunOS")) {
            store.addElement(tcpName);
        }
        Process p = null;
        Process q = null;
        try {
            p = Runtime.getRuntime().exec(command0);
            q = Runtime.getRuntime().exec(command1);
        }
        catch (IOException ioex) {
            String ioName = "RuntimeException";
            String ioString = DetectProtocolRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        InputStreamReader pIs = new InputStreamReader(p.getInputStream());
        InputStreamReader qIs = new InputStreamReader(q.getInputStream());
        BufferedReader pBr = new BufferedReader(pIs);
        BufferedReader qBr = new BufferedReader(qIs);
        try {
            p.waitFor();
            q.waitFor();
        }
        catch (InterruptedException itse) {
            String ioName = "RuntimeException";
            String ioString = DetectProtocolRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        String isLu = "";
        String isSpx = "";
        try {
            isLu = pBr.readLine();
            isSpx = qBr.readLine();
            if (isLu != null) {
                store.addElement(lu62Name);
            }
            if (isSpx != null) {
                store.addElement(spxName);
            }
        }
        catch (IOException ioe) {
            String ioName = "RuntimeException";
            String ioString = DetectProtocolRes.getString("RuntimeException_desc");
            throw new OiilQueryException(ioName, ioString);
        }
        int size = store.size();
        String[] retVal = new String[size];
        for (int j = 0; j < size; ++j) {
            retVal[j] = (String)store.elementAt(j);
        }
        return retVal;
    }

    public static void main(String[] args) {
        SolarisNetProtocol np = new SolarisNetProtocol();
        String[] retVal = null;
        try {
            retVal = (String[])np.performQuery(null);
        }
        catch (OiilQueryException q) {
            System.out.println(q.getMessage());
        }
        for (int x = 0; x < retVal.length; ++x) {
            System.out.println(retVal[x]);
        }
    }
}

